#include <iostream>

bool solve_knight_tour(int N, int board[][8], int x, int y, int step, int dx[8], int dy[8])
{
    board[x][y] = step;
    if (step == N*N) {
        // Posetili smo sva polja
        return true;
    }

    // Prolazimo kroz svih 8 L‑poteza skakaca
    for (int k = 0; k < 8; ++k) {
        int nx = x + dx[k];
        int ny = y + dy[k];
        // Provera da li je novo polje unutar table i neposećeno
        if (nx >= 0 && nx < N && ny >= 0 && ny < N && board[nx][ny] == 0) {
            if (solve_knight_tour(N, board, nx, ny, step + 1, dx, dy))
                return true;
        }
    }

    // Backtrack
    board[x][y] = 0;
    return false;
}

int main() {
    int N;
    std::cin >> N;

    // Tabla 8×8, ali koristićemo samo gornjih N×N polja
    int board[8][8] = {};  // sve ćelije inicijalno 0 (neposećeno)

    // dx i dy definišu svih 8 “L‑poteza” skakača:
    int dx[8] = {2, 1, -1, -2, -2, -1, 1, 2};
    int dy[8] = {1, 2, 2, 1, -1, -2, -2, -1};

    // Početni korak = 1 na polju (0,0)
    if (solve_knight_tour(N, board, 0, 0, 1, dx, dy)) {
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                std::cout << board[i][j] << (j + 1 < N ? ' ' : '\n');
            }
        }
    }
    else {
        std::cout << -1 << "\n";
    }

    return 0;
}
