#include <iostream>
#include <vector>
#define MAX 9

void load_sudoku(FILE *file, int sudoku[][9], int solution[][9])
{
    int number;

    for (int i = 0; i < MAX; i++)
        for (int j = 0; j < MAX; j++) {
            fscanf(file, "%d", &number);
            sudoku[i][j] = number;
            solution[i][j] = number;
        }
}

void print_sudoku(int sudoku[][9])
{
    for (int i = 0; i < MAX; i++) {
        for (int j = 0; j < MAX; j++)
            if (sudoku[i][j])
                std::cout << sudoku[i][j] << " ";
            else
                std::cout << "_ ";
        std::cout << "\n";
    }
}

void print_solution(int sudoku[][9], int solution[][9])
{
    for (int i = 0; i < MAX; i++) {
        for (int j = 0; j < MAX; j++) {
            if (sudoku[i][j] == 0)
                printf("\033[31m");
            else
                printf("\033[0m");
            std::cout << solution[i][j] << " ";
        }

        std::cout << "\n";
    }
}

bool check_row(int i, int value, int solution[][9])
{
    int counter = 0;

    for (int j = 0; j < MAX; j++)
        if (solution[i][j] == value)
            counter++;

    return counter == 1;
}

bool check_column(int j, int value, int solution[][9])
{
    int counter = 0;

    for (int i = 0; i < MAX; i++)
        if (solution[i][j] == value)
            counter++;

    return counter == 1;
}

bool check_square(int i, int j, int value, int solution[][9])
{
    int start_i = (i / 3) * 3;
    int start_j = (j / 3) * 3;
    int end_i = start_i + 3;
    int end_j = start_j + 3;

    int counter = 0;

    for (int i = start_i; i < end_i; i++) {
        for (int j = start_j; j < end_j; j++)
            if (solution[i][j] == value)
                counter++;
    }
    
    return counter == 1;
}

bool check_conflicts(int i, int j, int solution[][9])
{
    int value = solution[i][j];

    return check_row(i, value, solution) && check_column(j, value, solution) && check_square(i, j, value, solution);
}

bool solve_sudoku(int solution[][9])
{
    for (int i = 0; i < MAX; i++) {
        for (int j = 0; j < MAX; j++) {
            if (solution[i][j] == 0) {
                for (int value = 1; value <= 9; value++) {
                    solution[i][j] = value;

                    if (check_conflicts(i, j, solution)) {
                        if (solve_sudoku(solution))
                            return true;
                    }

                    solution[i][j] = 0;
                }

                return false;
            }
        }
    }

    return true;
}


int main ()
{
    std::string filename;
    int sudoku[MAX][MAX], solution[MAX][MAX];

    std::cin >> filename;

    FILE *file = fopen(filename.c_str(), "r");

    if (!file) { 
        std::cout << "Sudoku puzzle not found!\n";
        exit(EXIT_FAILURE);
    }

    load_sudoku(file, sudoku, solution);
    print_sudoku(sudoku);
    solve_sudoku(solution);
    print_solution(sudoku, solution);

    fclose(file);
    return 0;
}