#include <iostream>
#include <vector>

void backtrack(int idx, int sum, const std::vector<int> &a, int S, std::vector<int> &cur, bool &found)
{
    if (sum == S) {
        // Ispisujemo indekse tekućeg podskupa
        for (size_t i = 0; i < cur.size(); ++i) {
            std::cout << cur[i] << (i < cur.size() - 1 ? ' ' : '\n');
        }
        found = true;
        // Nasli smo jedno resenje, pa se vracamo nazad
        return ;
    }

    if (idx == a.size() || sum > S)
        return;

    // Ukljucimo a[idx]
    cur.push_back(idx);
    backtrack(idx + 1, sum + a[idx], a, S, cur, found);

    // Uklonimo a[idx] jer zelimo da nadjemo i podskupove koji ne ukljucuju ovaj element
    cur.pop_back();
    // Preskocimo a[idx]
    backtrack(idx + 1, sum, a, S, cur, found);
}

int main() {
    int n;
    int S;
    std::cin >> n >> S;

    std::vector<int> a(n);
    for (int i = 0; i < n; ++i) {
        std::cin >> a[i];
    }

    std::vector<int> cur;
    bool found = false;

    backtrack(0, 0, a, S, cur, found);

    if (!found) {
        std::cout << -1 << "\n";
    }

    return 0;
}
