#include <iostream>
#include <algorithm>
#define MAX 100
         
int LCS(const std::string &s1, int n1, std::string &s2, int n2)
{
    if (n1 == 0 || n2 == 0) {
        return 0;
    }

    if (s1[n1 - 1] == s2[n2 - 1])
        return LCS(s1, n1 - 1, s2, n2 - 1) + 1;

    int skracena_prva = LCS(s1, n1 - 1, s2, n2);
    int skracena_druga = LCS(s1, n1, s2, n2 - 1);

    return std::max(skracena_prva, skracena_druga);
}

int LCS_v2(const std::string &s1, int n1, std::string &s2, int n2, int matrica[][MAX])
{
    if (matrica[n1][n2] != -1) {
        return matrica[n1][n2];
    }

    int rez;

    if (n1 == 0 || n2 == 0) {
        rez = 0;
    }
    else if (s1[n1 - 1] == s2[n2 - 1]) {
        rez = LCS_v2(s1, n1 - 1, s2, n2 - 1, matrica) + 1;
    }
    else {
        int skracena_prva = LCS_v2(s1, n1 - 1, s2, n2, matrica);
        int skracena_druga = LCS_v2(s1, n1, s2, n2 - 1, matrica);

        rez = std::max(skracena_prva, skracena_druga);
    }

    matrica[n1][n2] = rez;
    return rez;
}

int main ()
{
    std::string s1, s2;

    std::cin >> s1;
    std::cin >> s2;

    int matrica[MAX][MAX];

    for (int i = 0; i <= s1.size(); i++) {
        for (int j = 0; j <= s2.size(); j++) {
            matrica[i][j] = -1;
        }
    }

    std::cout << LCS(s1, s1.size(), s2, s2.size()) << "\n";
    std::cout << LCS_v2(s1, s1.size(), s2, s2.size(), matrica) << "\n";

    return 0;
}