#include <iostream>
#include <vector>
#include <algorithm>

int editRastojanje(const std::string& s1, const std::string& s2, int n1, int n2) {
    if (n1 == 0)
        return n2; //* cenaUmetanja;

    if (n2 == 0)
        return n1; // * cenaBrisanja;

    if (s1[n1-1] == s2[n2-1])
        return editRastojanje(s1, s2, n1-1, n2-1);

    int r1 = editRastojanje(s1, s2, n1-1, n2) + 1; //cenaUmetanja;
    int r2 = editRastojanje(s1, s2, n1, n2-1) + 1; //cenaBrisanja;
    int r3 = editRastojanje(s1, s2, n1-1, n2-1) + 1; //cenaIzmene;

    return std::min({r1, r2, r3});
}

const int MAX = 100;
int memo[MAX][MAX];

int editRastojanje_2(const std::string& s1, const std::string& s2, int n1, int n2) {
    if (memo[n1][n2] != 0) {
        return memo[n1][n2];
    }

    if (n1 == 0) {
        memo[n1][n2] = n2; //* cenaUmetanja;
        return n2;
    }
    if (n2 == 0) {
        memo[n1][n2] = n1; // * cenaBrisanja;
        return n1;
    }

    if (s1[n1-1] == s2[n2-1]) {
        memo[n1][n2] = editRastojanje(s1, s2, n1-1, n2-1);
        return memo[n1][n2];
    }

    int r1 = editRastojanje(s1, s2, n1-1, n2) + 1; //cenaUmetanja;
    int r2 = editRastojanje(s1, s2, n1, n2-1) + 1; //cenaBrisanja;
    int r3 = editRastojanje(s1, s2, n1-1, n2-1) + 1; //cenaIzmene;

    int res = std::min({r1, r2, r3});

    memo[n1][n2] = res;
    return res;
}

int main ()
{
    std::string s1, s2;

    std::cin >> s1 >> s2;

    int n1 = s1.size(), n2 = s2.size();

    for (int i = 0; i < n1; i++) {
        memo[i][0] = i;
    }

    for (int j = 0; j < n2; j++) {
        memo[0][j] = j;
    }

    std::cout << editRastojanje_2(s1, s2, n1, n2) << "\n";
}