#include <iostream>
#include <vector>

// 1 1 2 3 5 8 13 21 34 55 89 144...

// fib(5)

//                                                                 fib(5)

//                                             fib(4)                                  fib(3)

//                             fib(3)                    fib(2)               fib(2)          fib(1)

//                     fib(2)          fib(1)


// [_,1,1,2,3,5]

long long fibonacci(int n)
{
    if (n == 1 || n == 2) {
        return 1;
    }

    return fibonacci(n - 1) + fibonacci(n - 2);
}

long long fibonacci_v2(int n, std::vector<long long> &memoization)
{
    if (memoization[n] != 0) {
        return memoization[n];
    }

    long long result;

    if (n == 1 || n == 2) {
        result = 1;
    }
    else
        result = fibonacci_v2(n - 1, memoization) + fibonacci_v2(n - 2, memoization);

    memoization[n] = result;
    return result;
}

long long fibonacci_v3(int n)
{
    std::vector<long long> fibonacci_array(n + 1);

    fibonacci_array[1] = 1;
    fibonacci_array[2] = 1;

    for (int i = 3; i <= n; i++)
        fibonacci_array[i] = fibonacci_array[i - 1] + fibonacci_array[i - 2];

    return fibonacci_array[n];
}

int main ()
{
    int n;

    std::cin >> n;

    // std::cout << fibonacci(n) << "\n";

    std::vector<long long> memoization(n + 1, 0);

    std::cout << fibonacci_v2(n, memoization) << "\n";

    // std::cout << fibonacci_v3(n) << "\n";

    return 0;
}