#include <iostream>
#define MAX 100

int broj_pojavljivanja(const std::string &niska, int duzina_niske, const std::string podniska, int duzina_podniske)
{
    if (duzina_podniske == 0)
        return 1;

    if (duzina_niske == 0)
        return 0;

    int broj_pojavljivanja_podniske = broj_pojavljivanja(niska, duzina_niske - 1, podniska, duzina_podniske);

    if (niska[duzina_niske - 1] == podniska[duzina_podniske - 1])
        broj_pojavljivanja_podniske += broj_pojavljivanja(niska, duzina_niske - 1, podniska, duzina_podniske - 1);

    return broj_pojavljivanja_podniske;
}

int broj_pojavljivanja_v2(const std::string &niska, int duzina_niske, const std::string podniska, int duzina_podniske, int matrica[MAX][MAX])
{
    if (matrica[duzina_niske][duzina_podniske] != -1)
        return matrica[duzina_niske][duzina_podniske];

    int broj_pojavljivanja_podniske;

    if (duzina_podniske == 0)
        broj_pojavljivanja_podniske = 1;
    else if (duzina_niske == 0)
        broj_pojavljivanja_podniske = 0;
    else {
        broj_pojavljivanja_podniske = broj_pojavljivanja_v2(niska, duzina_niske - 1, podniska, duzina_podniske, matrica);

        if (niska[duzina_niske - 1] == podniska[duzina_podniske - 1])
            broj_pojavljivanja_podniske += broj_pojavljivanja_v2(niska, duzina_niske - 1, podniska, duzina_podniske - 1, matrica);
    }

    matrica[duzina_niske][duzina_podniske] = broj_pojavljivanja_podniske;

    return broj_pojavljivanja_podniske;
}

int main ()
{
    std::string niska, podniska;

    std::cin >> niska;
    std::cin >> podniska;

    int matrica[MAX][MAX];

    for (int i = 0; i <= niska.size(); i++) {
        for (int j = 0; j <= podniska.size(); j++) {
            matrica[i][j] = -1;
        }
    }

    std::cout << broj_pojavljivanja(niska, niska.size(), podniska, podniska.size()) << "\n";
    std::cout << broj_pojavljivanja_v2(niska, niska.size(), podniska, podniska.size(), matrica) << "\n";

    return 0;
}