#include <iostream>
#include <vector>

int LIS(const std::vector<int> &a, int i, int prev)
{
    if (i == a.size()) {
        return 0;
    }

    int avoid = LIS(a, i + 1, prev);

    int include = 0;

    if (prev == -1 || a[i] > a[prev]) {
        include = 1 + LIS(a, i + 1, i);
    }

    return std::max(avoid, include);
}

int LIS_memo(const std::vector<int> &a, int i, int prev,
    std::vector<std::vector<int>> &memo)
{
    if (i == a.size()) {
        return 0;
    }

    if (memo[i][prev + 1] != -1) {
        return memo[i][prev + 1];
    }

    int avoid = LIS_memo(a, i + 1, prev, memo);

    int include = 0;

    if (prev == -1 || a[i] > a[prev]) {
        include = 1 + LIS_memo(a, i + 1, i, memo);
    }

    int result = std::max(avoid, include);

    memo[i][prev + 1] = result;
    return result;
}

int LIS_bu(const std::vector<int> &a)
{
    int n = a.size();
    std::vector<std::vector<int>> memo(n + 1, std::vector<int>(n + 1));

    for (int i = n - 1; i >= 0; i--) {
        for (int prev = -1; prev < i; prev++) {
            int avoid = memo[i + 1][prev + 1];

            int include = 0;

            if (prev == -1 || a[i] > a[prev]) {
                include = 1 + memo[i + 1][i + 1];
            }

            memo [i][prev + 1] = std::max(avoid, include);
        }
    }

    return memo[0][0];
}

int main ()
{
    int n;

    std::cin >> n;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << LIS(a, 0, -1) << "\n";

    std::vector<std::vector<int>> memo(n + 1, std::vector<int>(n + 1, -1));
    std::cout << LIS_memo(a, 0, -1, memo) << "\n";

    std::cout << LIS_bu(a) << "\n";
    return 0;
}