#include <iostream>
#include <vector>
#include <algorithm>

struct activity {
    long long start_time;
    long long end_time;
};

// Funkcija za sortiranje aktivnosti po vremenu završetka
bool compare_activities(const activity &a, const activity &b) {
    return a.end_time < b.end_time;
}

int main() {

    int activity_count;
    long long pause_time;

    std::cin >> activity_count >> pause_time;

    std::vector<activity> activities(activity_count);

    for (int i = 0; i < activity_count; i++) {
        std::cin >> activities[i].start_time >> activities[i].end_time;
    }

    // Sortiranje aktivnosti po zavrsetku
    std::sort(activities.begin(), activities.end(), compare_activities);

    int selected_count = 0;
    long long last_end_time = 0;

    for (int i = 0; i < activity_count; i++) {
        // Ako jos nismo uzeli nijednu aktivnost
        // ili je pauza ispostovana
        if (selected_count == 0 || activities[i].start_time >= last_end_time + pause_time) {
            selected_count++;
            last_end_time = activities[i].end_time;
        }
    }

    std::cout << selected_count << std::endl;

    return 0;
}
