#include <iostream>
#include <vector>

int subseq(const std::string &S, const std::string &T,
    int i, int j)
{
    if (j == T.size()) {
        return 1;
    }

    if (i == S.size()) {
        return 0;
    }

    int result = subseq(S, T, i + 1, j);

    if (S[i] == T[j]) {
        result += subseq(S, T, i + 1, j + 1);
    }

    return result;
}

int subseq_memo(const std::string &S, const std::string &T,
    int i, int j, std::vector<std::vector<int>> &memo)
{
    if (j == T.size()) {
        return 1;
    }

    if (i == S.size()) {
        return 0;
    }

    if (memo[i][j] != -1) {
        return memo[i][j];
    }

    int result = subseq_memo(S, T, i + 1, j, memo);

    if (S[i] == T[j]) {
        result += subseq_memo(S, T, i + 1, j + 1, memo);
    }

    memo[i][j] = result;

    return result;
}

int subseq_bu(const std::string &S, const std::string &T)
{
    std::vector<std::vector<int>> memo(S.size() + 1,
    std::vector<int>(T.size() + 1));

    int n = S.size(), m = T.size();

    for (int i = 0; i <= n; i++) {
        memo[i][m] = 1;
    }

    for (int i = n - 1; i >= 0; i--) {
        for (int j = m - 1; j >= 0; j--) {
            int result = memo[i + 1][j];

            if (S[i] == T[j]) {
                result += memo[i + 1][j + 1];
            }

            memo[i][j] = result;
        }
    }

    return memo[0][0];
}

int main ()
{
    std::string S, T;

    std::cin >> S >> T;

    std::cout << subseq(S, T, 0, 0) << "\n";

    std::vector<std::vector<int>> memo(S.size() + 1,
    std::vector<int>(T.size() + 1, -1));

    std::cout << subseq_memo(S, T, 0, 0, memo) << "\n";

    std::cout << subseq_bu(S, T) << "\n";

    return 0;
}