#include <iostream>
#include <vector>
#include <algorithm>

struct segment {
    long long left_point;
    long long right_point;
};

// Sortiranje:
// 1. Po početku segmenta rastuće
// 2. Ako imaju isti početak, uzimamo onaj koji se završava dalje
bool compare_segments(segment a, segment b) {

    if (a.left_point != b.left_point) {
        return a.left_point < b.left_point;
    }

    return a.right_point > b.right_point;
}

int main() {

    int segment_count;
    long long target_length;

    std::cin >> segment_count >> target_length;

    std::vector<segment> segments(segment_count);

    // Učitavanje segmenata
    for (int i = 0; i < segment_count; i++) {
        std::cin >> segments[i].left_point >> segments[i].right_point;
    }

    // Sortiranje segmenata
    std::sort(
        segments.begin(),
        segments.end(),
        compare_segments
    );

    long long covered_until = 0;  // trenutno pokriven interval [0, covered_until]
    int used_segments = 0;        // broj uzetih segmenata
    int index = 0;                // indeks kroz sortirane segmente

    // Dok ne pokrijemo celu dužinu [0, target_length]
    while (covered_until < target_length) {

        long long best_reach = covered_until;

        // Tražimo sve segmente koji mogu da nastave pokrivanje
        while (index < segment_count &&
               segments[index].left_point <= covered_until) {

            // Biramo segment koji ide najdalje udesno
            if (segments[index].right_point > best_reach) {
                best_reach = segments[index].right_point;
            }

            index++;
        }

        // Pomera se granica pokrivenog intervala
        covered_until = best_reach;

        used_segments++;
    }

    std::cout << used_segments << std::endl;

    return 0;
}
