#include <iostream>
#include <vector>
#include <algorithm>
#include <limits>
#include <climits>

struct Rezultat {
    int minimum;           // najmanji element u segmentu
    int maksimum;          // najveci element u segmentu
    int najbolja_razlika;  // najbolji skok a[j] - a[i] u segmentu (i < j)
};

Rezultat najveci_skok(const std::vector<int> &a, int l, int d)
{
    if (l == d) {
        Rezultat r;
        r.minimum = a[l];
        r.maksimum = a[l];
        r.najbolja_razlika = INT_MIN; //std::numeric_limits<int>::min();
        return r;
    }

    int s = l + (d - l) / 2;

    // Rekurzivno resavamo levo i desno
    Rezultat levo = najveci_skok(a, l, s);
    Rezultat desno = najveci_skok(a, s + 1, d);

    Rezultat r;

    r.minimum = std::min(levo.minimum, desno.minimum);
    r.maksimum = std::max(levo.maksimum, desno.maksimum);

    int preko_sredine = desno.maksimum - levo.minimum;

    r.najbolja_razlika = std::max({levo.najbolja_razlika,
                                   desno.najbolja_razlika,
                                   preko_sredine});

    return r;
}

int najveci_skok(const std::vector<int> &a)
{
    Rezultat r = najveci_skok(a, 0, (int)a.size() - 1);
    return r.najbolja_razlika;
}

int main()
{
    int n;
    std::cin >> n;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << najveci_skok(a) << "\n";

    return 0;
}
