#include <iostream>
#include <vector>
#include <algorithm>

int broj_inverzija(std::vector<int> &a, int l, int d, std::vector<int> &b)
{
    if (l >= d) {
        return 0;
    }

    int s = l + (d - l) / 2;

    int broj = 0;
    // Broj inverzija u levoj polovini niza
    broj += broj_inverzija(a, l, s, b);
    // Broj inverzija u desnoj polovini niza
    broj += broj_inverzija(a, s + 1, d, b);

    int pokazivac_levo = l, pokazivac_desno = s + 1, pokazivac_niz_b = 0;

    while (pokazivac_levo <= s && pokazivac_desno <= d) {
        if (a[pokazivac_levo] <= a[pokazivac_desno]) {
            b[pokazivac_niz_b++] = a[pokazivac_levo++];
        }
        else {
            broj += s - pokazivac_levo + 1;
            b[pokazivac_niz_b++] = a[pokazivac_desno++];
        }
    }

    while (pokazivac_levo <= s) {
        b[pokazivac_niz_b++] = a[pokazivac_levo++];
    }

    while (pokazivac_desno <= d) {
        b[pokazivac_niz_b++] = a[pokazivac_desno++];
    }

    for (int i = l; i <= d; i++) {
        a[i] = b[i];
    }

    return broj;
}

int broj_inverzija(std::vector<int> &a)
{
    std::vector<int> b(a.size());
    return broj_inverzija(a, 0, a.size() - 1, b);
}

int main ()
{
    int n;

    std::cin >> n;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << broj_inverzija(a) << "\n";

    return 0;
}