#include <iostream>
#include <vector>
#include <algorithm>

int k_ti_najmanji(const std::vector<int> &a, int pokazivac_a, const std::vector<int> &b, int pokazivac_b, int k)
{
    // Ako smo "potrosili" ceo niz a,
    // k-ti element je u nizu b
    if (pokazivac_a >= a.size()) {
        return b[pokazivac_b + k - 1];
    }

    // Ako smo "potrosili" ceo niz b,
    // k-ti element je u nizu a
    if (pokazivac_b >= b.size()) {
        return a[pokazivac_a + k - 1];
    }

    if (k == 1) {
        return std::min(a[pokazivac_a], b[pokazivac_b]);
    }

    int k_pola = k / 2;

    int indeks_a = std::min(pokazivac_a + k_pola, (int) a.size()) - 1;
    int indeks_b = std::min(pokazivac_b + k_pola, (int) b.size()) - 1;

    // Ako je element iz niza a manji ili jednak,
    // onda svi elementi a[pokazivac_a .. indeks_a]
    // sigurno NE mogu biti k-ti
    if (a[indeks_a] <= b[indeks_b]) {
        int odbaceni = indeks_a - pokazivac_a + 1;
        return k_ti_najmanji(a, pokazivac_a + odbaceni, b, pokazivac_b, k - odbaceni);
    }
    else {
        // Slicno odbacujemo deo niza b
        int odbaceni = indeks_b - pokazivac_b + 1;
        return k_ti_najmanji(a, pokazivac_a, b, pokazivac_b + odbaceni, k - odbaceni);
    }
}

int k_ti_najmanji(const std::vector<int> &a, const std::vector<int> &b, int k)
{
    return k_ti_najmanji(a, 0, b, 0, k);
}

int main()
{
    int n, m, k;

    std::cin >> n >> m >> k;

    std::vector<int> a(n), b(m);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    for (int i = 0; i < m; i++) {
        std::cin >> b[i];
    }

    std::cout << k_ti_najmanji(a, b, k) << "\n";

    return 0;
}
