#include <iostream>
#include <vector>
#include <algorithm>

int max_suma_segmenta(const std::vector<int> &a, int l, int d)
{
    if (l > d) {
        return 0;
    }

    int s = l + (d - l) / 2;

    int max_suma_levo = max_suma_segmenta(a, l, s - 1);
    int max_suma_desno = max_suma_segmenta(a, s + 1, d);

    int suma_sredina = a[s];
    int max_suma_sredina = suma_sredina;

    for (int i = s - 1; i >= l; i--) {
        suma_sredina += a[i];
        max_suma_sredina = std::max(max_suma_sredina, suma_sredina);
    }

    suma_sredina = max_suma_sredina;

    for (int i = s + 1; i <= d; i++) {
        suma_sredina += a[i];
        max_suma_sredina = std::max(max_suma_sredina, suma_sredina);
    }

    return std::max({max_suma_levo, max_suma_desno, max_suma_sredina});
}

int max_suma_segmenta(const std::vector<int> &a)
{
    return max_suma_segmenta(a, 0, a.size() - 1);
}

int main ()
{
    int n;

    std::cin >> n;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << max_suma_segmenta(a) << "\n";

    return 0;
}