#include <iostream>
#include <vector>

void merge_sort(std::vector<int> &a, int l, int d, std::vector<int> &b)
{
    if (l == d) {
        return ;
    }

    int s = l + (d - l) / 2;

    merge_sort(a, l, s, b);
    merge_sort(a, s + 1, d, b);

    int pokazivac_l = l;
    int pokazivac_d = s + 1;

    int k = l;
    while (pokazivac_l <= s && pokazivac_d <= d) {
        if (a[pokazivac_l] < a[pokazivac_d]) {
            b[k++] = a[pokazivac_l++];
        }
        else {
            b[k++] = a[pokazivac_d++];
        }
    }

    while (pokazivac_l <= s) {
        b[k++] = a[pokazivac_l++];
    }

    while (pokazivac_d <= d) {
        b[k++] = a[pokazivac_d++];
    }

    for (int i = l; i <= d; i++) {
        a[i] = b[i];
    }
}

void merge_sort(std::vector<int> &a)
{
    std::vector<int> b(a.size());
    merge_sort(a, 0, a.size() - 1, b);
}

int main ()
{
    int n;

    std::cin >> n;

    std::vector<int> a(n);

    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    merge_sort(a);

    return 0;
}