#include <iostream>
#include <vector>
#include <algorithm>

// Broji intervale (tj. parove u<v) takve da je a[v] - a[u] > T,
// i usput sortira a[l..d] (merge-sort stil).
int broj_intervala(std::vector<int> &a, int l, int d,
                         std::vector<int> &pom, int T)
{
    if (l >= d) {
        return 0;
    }

    int s = l + (d - l) / 2;

    int broj = 0;

    // Levo + desno
    broj += broj_intervala(a, l, s, pom, T);
    broj += broj_intervala(a, s + 1, d, pom, T);

    int pokazivac_levo = l;

    for (int pokazivac_desno = s + 1; pokazivac_desno <= d; pokazivac_desno++) {

        // Pomeri pokazivac_levo dokle god je razlika > T.
        // Kad prestane, znaci da su svi pre toga (od l do pokazivac_levo - 1)
        // bili dobri poceci za ovaj kraj (fiksiran pokazivac_desno).
        while (pokazivac_levo <= s && a[pokazivac_desno] - a[pokazivac_levo] > T) {
            pokazivac_levo++;
        }

        broj += (pokazivac_levo - l);
    }

    int i = l;
    int j = s + 1;
    int k = l;

    while (i <= s && j <= d) {
        if (a[i] <= a[j]) {
            pom[k++] = a[i++];
        } else {
            pom[k++] = a[j++];
        }
    }

    while (i <= s) {
        pom[k++] = a[i++];
    }

    while (j <= d) {
        pom[k++] = a[j++];
    }

    for (int i = l; i <= d; i++) {
        a[i] = pom[i];
    }

    return broj;
}

int broj_intervala(const std::vector<int> &a, int T)
{
    int n = (int)a.size();

    // Prefiksne sume a[0..n]
    std::vector<int> prefiksne_sume(n + 1, 0);

    for (int i = 1; i <= n; i++) {
        prefiksne_sume[i] = prefiksne_sume[i - 1] + a[i - 1];
    }

    std::vector<int> pom(n + 1);

    return broj_intervala(prefiksne_sume, 0, n, pom, T);
}

int main()
{
    int n;
    int T;

    std::cin >> n >> T;

    std::vector<int> a(n); // 3 -2 1 -1 4 -3
    for (int i = 0; i < n; i++) {
        std::cin >> a[i];
    }

    std::cout << broj_intervala(a, T) << "\n";

    return 0;
}
